import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/bloc.dart';

class LogoutButton extends StatefulWidget {
  const LogoutButton({Key? key}) : super(key: key);

  @override
  _LogoutButtonState createState() => _LogoutButtonState();
}

class _LogoutButtonState extends State<LogoutButton> {
  var _isLoggingOut = false;

  @override
  build(context) {
    return Button(
      className: 'btn btn-primary hidden-sm-and-down',
      innerText: _isLoggingOut ? 'Logging out...' : 'Log out',
      disabled: _isLoggingOut,
      onClick: _doLogout,
    );
  }

  void _doLogout(EmittedEvent event) async {
    if (_isLoggingOut) return;

    setState(() {
      _isLoggingOut = true;
    });

    try {
      var responseModel = await AppProvider.of(context).apiRepo.preparedRequest(
        requestType: REQ_TYPE_ADMIN_LOGOUT,
        requestData: {},
      );

      if (SUCCESS_MSG == responseModel.message) {
        AuthBloc.of(context).pushEvent(AuthEventLogout(context));
      }
    } catch (e) {
      AppLogger.exception(e);
    }

    setState(() {
      _isLoggingOut = false;
    });
  }
}
